/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils.jsse;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.jsse.IWSJSSEContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.components.net.SocketFactory;

public class WSJSSE {
    private String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private String keystoreType = KeyStore.getDefaultType();
    private String protocol = "SSL";
    private String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String m_desc = null;
    private static WSJSSE gWSJSSE = null;
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    private static final String m_className = "WSJSSE";
    public static final String TRUSTSTORE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD_PROPERTY = "javax.net.ssl.trustStorePassword";
    public static final String STORE_DEFAULT_PASSWORD = "changeit";
    public static final String KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    private static final char[] DEFAULT_KEYPASS = "changeit".toCharArray();
    private static final String AXIS_SSL_FACTORY_PROPERTY = "org.apache.axis.components.net.SecureSocketFactory";
    private static final String FILENET_SUN_SSL_FACTORY_CLASS = "filenet.ws.utils.jsse.FnJSSESocketFactory";
    private static final String FILENET_IBM_SSL_FACTORY_CLASS = "filenet.ws.utils.jsse.FnIBMJSSESocketFactory";
    private static String g_socketFactoryClass = "filenet.ws.utils.jsse.FnJSSESocketFactory";
    private static ClassLoader g_socketFactoryClassLoader = null;
    private static final Object g_SyncObj = new Object();
    private static Boolean g_socketFactoryClassInit = Boolean.FALSE;
    private static Boolean g_UseListenerProperties = Boolean.FALSE;
    private static WSListenerProperties g_WSListenerProps = null;

    public String toString() {
        if (this.m_desc == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("WSJSSE:").append("trustManagerAgorithm=").append(this.trustManagerAlgorithm).append(", protocol=").append(this.protocol).append(",keystoreType=").append(this.keystoreType).append(", keyManagerAlgorithm=").append(this.keyManagerAlgorithm);
            this.m_desc = buf.toString();
        }
        return this.m_desc;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public String getKeyStoreType() {
        return this.keystoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private WSJSSE() {
        String baseProperty = "filenet.ws.utils.jsse.WSJSSE.";
        this.setKeyManagerAlgorithm(WSJSSE.getPrivilegedSystemProperty(baseProperty + ".keyManagerAlgorithm"));
        this.setTrustManagerAlgorithm(WSJSSE.getPrivilegedSystemProperty(baseProperty + ".trustManagerAlgorithm"));
        this.setKeystoreType(WSJSSE.getPrivilegedSystemProperty(baseProperty + ".keystoreType"));
        this.setProtocol(WSJSSE.getPrivilegedSystemProperty(baseProperty + ".protocol"));
    }

    private void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        if (trustManagerAlgorithm != null) {
            this.trustManagerAlgorithm = trustManagerAlgorithm;
        }
    }

    private void setKeystoreType(String keystoreType) {
        if (keystoreType != null) {
            this.keystoreType = keystoreType;
        }
    }

    private void setProtocol(String protocol) {
        if (protocol != null) {
            this.protocol = protocol;
        }
    }

    private void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        if (keyManagerAlgorithm != null) {
            this.keyManagerAlgorithm = keyManagerAlgorithm;
        }
    }

    public static synchronized WSJSSE getInstance() {
        if (gWSJSSE == null) {
            gWSJSSE = new WSJSSE();
            if (logger.isFinest()) {
                logger.finest(m_className, "getInstance", gWSJSSE.toString());
            }
        }
        return gWSJSSE;
    }

    public static WSJSSE getInstance(String trustManagerAlgorithm, String keystoreType, String protocol, String keyManagerAlgorithm) {
        WSJSSE res = new WSJSSE();
        res.setTrustManagerAlgorithm(trustManagerAlgorithm);
        res.setKeystoreType(keystoreType);
        res.setProtocol(protocol);
        res.setKeyManagerAlgorithm(keyManagerAlgorithm);
        return res;
    }

    public static void traceProperties() {
        String m_method = "traceProperties";
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        String s = "javax.net.ssl.trustStore=" + WSJSSE.getPrivilegedSystemProperty(TRUSTSTORE_PROPERTY) + "," + TRUSTSTORE_PASSWORD_PROPERTY + "=" + WSJSSE.getPrivilegedSystemProperty(TRUSTSTORE_PASSWORD_PROPERTY);
        if (logger.isFinest()) {
            logger.finest(m_className, "traceProperties", s);
        }
    }

    public static String getDefaultTrustStorePath() {
        String path = WSJSSE.getPrivilegedSystemProperty(TRUSTSTORE_PROPERTY);
        if (path == null) {
            path = WSJSSE.getPrivilegedSystemProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        }
        return path;
    }

    public static char[] getDefaultTrustStorePassword() {
        String pw = WSJSSE.getPrivilegedSystemProperty(TRUSTSTORE_PASSWORD_PROPERTY);
        if (pw != null) {
            return pw.toCharArray();
        }
        return DEFAULT_KEYPASS;
    }

    public static boolean getAutoTrustSSL() {
        String s = WSJSSE.getPrivilegedSystemProperty("filenet.ws.ssl.autotrust");
        return s == null || s.equals("true");
    }

    public static void setAutoTrustSSL(boolean val) {
        System.setProperty("filenet.ws.ssl.autotrust", new Boolean(val).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSocketFactoryClass(WSListenerProperties gWSListenerProperties) throws VWException {
        Object object = g_SyncObj;
        synchronized (object) {
            if (g_socketFactoryClassInit.booleanValue()) {
                return g_socketFactoryClass;
            }
            String m_method = "getSocketFactoryClass";
            boolean autoAccept = WSJSSE.getAutoAccept(gWSListenerProperties);
            String res = WSJSSE.getPrivilegedSystemProperty("cm.JSSE.factory.class");
            if (res == null && gWSListenerProperties != null) {
                res = gWSListenerProperties.getProperty("cm.JSSE.factory.class");
            }
            boolean bOK = false;
            if (res == null) {
                res = FILENET_SUN_SSL_FACTORY_CLASS;
            }
            try {
                g_socketFactoryClassLoader = Thread.currentThread().getContextClassLoader();
                g_socketFactoryClassLoader.loadClass(res);
                bOK = true;
            }
            catch (Throwable t) {
                while (g_socketFactoryClassLoader.getParent() != null) {
                    g_socketFactoryClassLoader = g_socketFactoryClassLoader.getParent();
                    try {
                        if (logger.isFinest()) {
                            logger.finest(m_className, "getSocketFactoryClass", "-- going up the list" + g_socketFactoryClassLoader.toString());
                        }
                        g_socketFactoryClassLoader.loadClass(res);
                        bOK = true;
                    }
                    catch (Throwable tt) {
                        // empty catch block
                    }
                    bOK = false;
                }
            }
            if (!bOK) {
                throw new NullPointerException("No class for JSSE Socket Factory is found");
            }
            if (logger.isFinest()) {
                logger.finest(m_className, "getSocketFactoryClass", res);
            }
            g_socketFactoryClass = res;
            g_socketFactoryClassInit = Boolean.TRUE;
        }
        return g_socketFactoryClass;
    }

    public static void useListenerProperties(WSListenerProperties props) {
        g_WSListenerProps = props;
        g_UseListenerProperties = Boolean.TRUE;
    }

    public static void setupJSSEProperties(IWSJSSEContext context) {
        String m_method = "setupJSSEProperties";
        String keystore = null;
        String truststore = null;
        String keystorePassword = null;
        String truststorePassword = null;
        boolean autoAccept = WSJSSE.getAutoAccept(null);
        try {
            block12: {
                if (g_UseListenerProperties.booleanValue() && g_WSListenerProps != null) {
                    WSListenerProperties props = null;
                    try {
                        props = g_WSListenerProps;
                        keystore = props.getKeystoreFile();
                        truststore = props.getTruststoreFile();
                        keystorePassword = props.getKeystorePassword();
                        truststorePassword = props.getTruststorePassword();
                        autoAccept = props.getCertificatesAutoAccept();
                        props = null;
                    }
                    catch (Throwable t) {
                        if (!logger.isFinest()) break block12;
                        logger.finest(m_className, "setupJSSEProperties", "Ignore it.." + t.getMessage());
                    }
                }
            }
            if (truststore == null) {
                if (autoAccept) {
                    truststore = WSJSSE.getPrivilegedSystemProperty("java.io.tmpdir") + File.separator + "cacerts";
                    truststorePassword = new String(WSJSSE.getDefaultTrustStorePassword());
                    if (!new File(truststore).exists()) {
                        truststore = WSJSSE.getDefaultTrustStorePath();
                    }
                    if (new File(truststore).exists()) {
                        System.setProperty(TRUSTSTORE_PROPERTY, truststore);
                        System.setProperty(TRUSTSTORE_PASSWORD_PROPERTY, truststorePassword);
                    }
                } else {
                    truststore = WSJSSE.getPrivilegedSystemProperty(TRUSTSTORE_PROPERTY);
                    truststorePassword = WSJSSE.getPrivilegedSystemProperty(TRUSTSTORE_PASSWORD_PROPERTY);
                    if (truststore == null) {
                        truststore = WSJSSE.getDefaultTrustStorePath();
                        truststorePassword = new String(WSJSSE.getDefaultTrustStorePassword());
                    }
                }
                keystore = truststore;
                keystorePassword = truststorePassword;
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "setupJSSEProperties", e);
        }
        File f = new File(truststore);
        context.setKeystore(keystore);
        context.setTruststore(truststore);
        context.setKeystorePassword(keystorePassword);
        context.setTruststorePassword(truststorePassword);
        context.setAutoAccept(autoAccept);
        context.traceStoreProperties();
        if (autoAccept && f.exists() && !f.canWrite()) {
            String s = new VWString("filenet.ws.jsse.warning.FileCannotBeWritten", "Cannot write to {0}.  SSL invocations may result in UntrustedCertificates Exception.").toString(truststore);
            logger.warning(m_className, "setupJSSEProperties", s);
        }
    }

    public static boolean getAutoAccept(WSListenerProperties props) {
        if (props == null) {
            return WSJSSE.getAutoTrustSSL();
        }
        return props.getCertificatesAutoAccept();
    }

    public static void installAxisJSSESocketFactory(WSListenerProperties gWSListenerProperties) throws Exception {
        String m_method = "installJSSESocketFactory";
        String sslSocketFactoryClass = null;
        try {
            try {
                logger.entering(m_className, "installJSSESocketFactory");
                if (gWSListenerProperties != null) {
                    WSJSSE.useListenerProperties(gWSListenerProperties);
                }
                WSJSSE.STATIC_INITIALIZER();
                sslSocketFactoryClass = WSJSSE.getSocketFactoryClass(gWSListenerProperties);
                System.setProperty(AXIS_SSL_FACTORY_PROPERTY, sslSocketFactoryClass);
                logger.info(m_className, "installJSSESocketFactory", "Setting org.apache.axis.components.net.SecureSocketFactory=" + sslSocketFactoryClass);
            }
            catch (Exception ex) {
                logger.throwing(m_className, "installJSSESocketFactory", ex);
                throw ex;
            }
            Object var5_3 = null;
            logger.exiting(m_className, "installJSSESocketFactory");
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            logger.exiting(m_className, "installJSSESocketFactory");
            throw throwable;
        }
    }

    public static SocketFactory getSSLSocketFactory() throws Exception {
        String m_method = "getSSLSocketFactory";
        String sslSocketFactoryClass = WSJSSE.getSocketFactoryClass(null);
        Class<?> cls = g_socketFactoryClassLoader.loadClass(sslSocketFactoryClass);
        Constructor<?> cons = cls.getConstructor(Hashtable.class);
        return (SocketFactory)cons.newInstance(new Object[]{null});
    }

    /*
     * Loose catch block
     */
    public static String getContentsOld(String httpsURL) throws Exception {
        Exception e2222;
        String string;
        String res;
        PrintWriter outS;
        PrintWriter outF;
        BufferedReader inS;
        Socket socket;
        String m_method;
        block34: {
            m_method = "getContents:" + httpsURL;
            socket = null;
            inS = null;
            outF = null;
            outS = null;
            res = null;
            logger.entering(m_className, m_method);
            URL url = null;
            SocketFactory socketFactory = WSJSSE.getSSLSocketFactory();
            url = new URL(httpsURL);
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = 443;
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "creating socket " + host + ":" + Integer.toString(port));
            }
            socket = (SSLSocket)socketFactory.create(host, port, null, null);
            outS = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
            outS.println("GET " + httpsURL + " HTTP/1.0");
            outS.println();
            outS.flush();
            if (outS.checkError()) {
                String s = "Failed to write to " + httpsURL;
                VWException ex = new VWException("filenet.ws.utils.failedToWriteToHttps", "Failed to write to {0}", httpsURL);
                logger.throwing(m_className, m_method, ex);
                throw ex;
            }
            inS = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            File f = File.createTempFile("fnws", ".wsdl");
            String inputLine = inS.readLine();
            if (inputLine.indexOf("200 OK") == -1) {
                String s = "Failed to GET " + httpsURL + ", status=" + inputLine;
                VWException ex = new VWException("filenet.ws.utils.failedToGetHttpsURL", "Failed to GET {0}, status={1}", httpsURL, inputLine);
                logger.throwing(m_className, m_method, ex);
                throw ex;
            }
            while ((inputLine = inS.readLine()) != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "[HTTP HEADER]" + inputLine);
                }
                if (inputLine.trim().length() != 0) continue;
            }
            StringBuffer buf = new StringBuffer();
            outF = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            while ((inputLine = inS.readLine()) != null) {
                outF.println(inputLine);
                buf.append(inputLine).append("\n");
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, buf.toString());
            }
            inS.close();
            inS = null;
            outS.close();
            outS = null;
            outF.close();
            outF = null;
            socket.close();
            socket = null;
            string = res = f.getCanonicalPath();
            Object var16_21 = null;
            if (inS == null) break block34;
            try {
                inS.close();
            }
            catch (Exception e2222) {
                // empty catch block
            }
        }
        if (outS != null) {
            try {
                outS.close();
            }
            catch (Exception e2222) {
                // empty catch block
            }
        }
        if (outF != null) {
            try {
                outF.close();
            }
            catch (Exception e2222) {
                // empty catch block
            }
        }
        if (socket != null) {
            try {
                socket.close();
                socket = null;
            }
            catch (Exception e2222) {
                // empty catch block
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "EXIT, res=" + res);
        }
        return string;
        catch (Exception ex) {
            try {
                logger.throwing(m_className, m_method, ex);
                throw ex;
            }
            catch (Throwable throwable) {
                block38: {
                    Exception e2222;
                    Object var16_22 = null;
                    if (inS != null) {
                        try {
                            inS.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (outS != null) {
                        try {
                            outS.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (outF != null) {
                        try {
                            outF.close();
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                            socket = null;
                        }
                        catch (Exception e2222) {
                            // empty catch block
                        }
                    }
                    if (!logger.isFinest()) break block38;
                    logger.finest(m_className, m_method, "EXIT, res=" + res);
                }
                throw throwable;
            }
        }
    }

    public static void STATIC_INITIALIZER() {
        try {
            SocketFactory socketFactory = WSJSSE.getSSLSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(((IWSJSSEContext)socketFactory).getSSLSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new WSJSSEHostVerifier());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(String httpsURL) throws Exception {
        Exception e22;
        String string;
        BufferedReader data;
        block13: {
            String m_method = "getContents:" + httpsURL;
            URLConnection conn = null;
            data = null;
            File f = File.createTempFile("fnws", ".wsdl");
            PrintWriter outF = null;
            try {
                String line;
                outF = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                URL theURL = new URL(httpsURL);
                conn = theURL.openConnection();
                conn.connect();
                data = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((line = data.readLine()) != null) {
                    if (logger.isFinest()) {
                        logger.finest(m_className, m_method, "Line = " + line);
                    }
                    outF.println(line);
                }
                String res = f.getCanonicalPath();
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, res);
                }
                string = res;
                Object var11_10 = null;
                if (outF == null) break block13;
            }
            catch (Throwable throwable) {
                block15: {
                    Exception e22;
                    Object var11_11 = null;
                    if (outF != null) {
                        try {
                            outF.close();
                            outF = null;
                        }
                        catch (Exception e22) {
                            // empty catch block
                        }
                    }
                    if (data == null) break block15;
                    try {
                        data.close();
                        data = null;
                    }
                    catch (Exception e22) {}
                }
                throw throwable;
            }
            try {
                outF.close();
                outF = null;
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (data != null) {
            try {
                data.close();
                data = null;
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        return string;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 18:16:08  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.10  $";
    }

    static class WSJSSEHostVerifier
    implements HostnameVerifier {
        WSJSSEHostVerifier() {
        }

        public boolean verify(String url, SSLSession session) {
            try {
                InetAddress iaU = InetAddress.getByName(url);
                InetAddress iaC = InetAddress.getByName(session.getPeerHost());
                return iaU.equals(iaC);
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

